      IMPLICIT NONE
      
      REAL*8,PARAMETER :: nol=0.0d0
      REAL*8 :: pi
      
      REAL*8,EXTERNAL :: TRIAN, EX, K_OC, K_FERMI, K_PHON
      COMPLEX, EXTERNAL :: G_MATS_TRI
      
      REAL*8,ALLOCATABLE,DIMENSION(:) :: gr, ta, sigma
      REAL*8,ALLOCATABLE,DIMENSION(:) :: gr_2, gi_2, ta_2, sigma_2
      REAL*8,ALLOCATABLE,DIMENSION(:) :: spe, spe_ti, spe_mats, omeg
      COMPLEX,ALLOCATABLE,DIMENSION(:) :: G_n, O_n, G_from_mats

      COMPLEX :: o_com_now, ta_compl
      REAL*8 :: om_dia, om_1, z_1, a1, a2, a3, za, b1, b2, b3, zb 
      REAL*8 :: c1, c2, c3, zc, phi
      REAL*8 :: time, relative_eb_com, relative_eb_ima, beta, intended_norma
      REAL*8 :: om, anor, bukil, e1, e2, om_sha, t_sha, zdf, nor_core
      REAL*8 :: time_2, t_sha_2
      REAL*8 :: anor_tilda
      
      INTEGER :: kernel_type, nfu, ntim, ntim_2, n_matsu, i, jj, idf, j 
      
  102 format(1x,1(e13.6,' '),e13.6)   	 	 	 
  103 format(1x,2(e13.6,' '),e13.6)   	 	 	 

      pi=2.0d0*ASIN(1.0d0)
      
      PRINT*,"*****  This is TEST-MAKER of 2015.07.28  *********** "
      
! input data      
      OPEN(4,file='inpu_test.in')
      READ(4,*)kernel_type        ! type of kernel
      READ(4,*)om_dia, nfu       ! range of spectra & number of omega points 
      READ(4,*)om_1, z_1         ! center & weight of anzac
      READ(4,*)a1, a2, a3, za    ! beginning, middle, end, and weight of triangle 1
      READ(4,*)b1, b2, b3, zb    ! beginning, middle, end, and weight of triangle 1
      READ(4,*)c1, c2, c3, zc     ! beginning, middle, end, and weight of triangle 1
      READ(4,*)time, ntim         ! max imaginary time & number of points or Matsubaras
      READ(4,*)relative_eb_com, relative_eb_ima ! relative errorbar for complex and imaginary
      READ(4,*)beta                  ! inverse temperature
      READ(4,*)intended_norma ! intended norma
      READ(4,*)time_2,ntim_2   !max complex time and number of complex time points
      READ(4,*)phi                  !angle for complex \tau
      CLOSE(4)
      n_matsu=ntim
      
      PRINT*,"The test for kernel No ",kernel_type,"   is prepared."
      
! checking consistencies
      SELECT CASE(kernel_type)
      CASE(0,6,7)
         IF(a1<nol .OR. a2<nol .OR. a3<nol) &
         STOP"a No negatives in case 0"       
         IF(b1<nol .OR. b2<nol .OR. b3<nol) &
         STOP"b No negatives in case 0"        
         IF(c1<nol .OR. c2<nol .OR. c3<nol) &
         STOP"c No negatives in case 0"        
      CASE(1)
          IF(ABS(time-beta)>1.0d-10)THEN
              PRINT*," beta : ",beta,"  time : ",time
              STOP"Need time=beta to check sum rules"
          ENDIF   
          IF(z_1>1.0d-20)STOP'No anzac for kernel_type/=0 possible'
      CASE(2)
          IF(z_1>1.0d-20)STOP'No anzac for kernel_type/=0 possible'
      CASE(3)
         IF(z_1>1.0d-20)STOP'No anzac for kernel_type/=0 possible'    
      CASE(4)
         IF(z_1>1.0d-20)STOP'No anzac for kernel_type/=0 possible'
      CASE(5)
         IF(z_1>1.0d-20)STOP'No anzac for kernel_type/=0 possible'
      END SELECT    
      
! Kernel_type =     
!     0  -  exp(-\omega \tau)
!     1  -  optical conductivity finite T
!     2  -  Fermi finite T imaginary time
!     3  -  Bose  finite T imaginary time symmetrized      
!     4  -  Fermi finite T Matsubara
!     5  -  Bose  finite T Matsubara             
!     6  -  exp(-\omega \tau exp(i\phi)) -slanted \tau --> \tau exp(i\phi)    
!     7  -  exp(-\omega \tau exp(i\phi)) -slanted \tau and imaginary exp(-\omega \tau)

      PRINT*,"ALLOCATING"
! allocating      
      SELECT CASE(kernel_type)
         CASE(0, 1, 2, 3)
            ALLOCATE( gr(ntim), ta(ntim), sigma(ntim) ) ! real G(tau)
         CASE(4, 5)
            ALLOCATE( O_n(-n_matsu:n_matsu),  G_n(-n_matsu:n_matsu)) ! complex Matsubara
            ALLOCATE( sigma(-n_matsu:n_matsu) ) ! still real
            ALLOCATE( G_from_mats(ntim) )
            ALLOCATE( ta(ntim), gr(ntim) )
         CASE(6)
            ALLOCATE( gr_2(ntim_2), gi_2(ntim_2), ta_2(ntim_2), sigma_2(ntim_2) ) ! real&imag G(tau)
         CASE(7)
            ALLOCATE( gr(ntim), ta(ntim), sigma(ntim) ) ! real G(tau) for imaginary tau
            ALLOCATE( gr_2(ntim_2), gi_2(ntim_2), ta_2(ntim_2), sigma_2(ntim_2) ) ! real&imag G(tau) for complex
      END SELECT
      
      ALLOCATE( spe(nfu), spe_ti(nfu), spe_mats(nfu), omeg(nfu) )
      
! setting relative errorbars 
      SELECT CASE(kernel_type)
          CASE(0, 1, 2, 3, 4, 5)
             sigma = relative_eb_ima
          CASE(6)
             sigma_2 = relative_eb_com
          CASE(7)
             sigma_2 = relative_eb_com
             sigma = relative_eb_ima
     END SELECT
        
       PRINT*,"SETTING THE SPECTRUM"
! SETTING THE SPECTRUM     
! free spectrum
      SELECT CASE(kernel_type)
         CASE(0, 1, 3, 6, 7) ! initial spectrum is in the range [0, om_max]   
         om_sha = om_dia/nfu
         DO i=1,nfu
            om=(i-1.0)*om_sha; 
            omeg(i)=om
            spe(i) = trian(om,a1,a2,a3,za) + trian(om,b1,b2,b3,zb) &
                      + trian(om,c1,c2,c3,zc)
         ENDDO
      CASE(2, 4, 5) ! initial spectrum is in the range [-om_max, om_max] 
         om_sha = 2*om_dia/nfu
         DO i=1,nfu
            om=-om_dia+(i-1.0)*om_sha; 
            omeg(i)=om
            spe(i) = trian(om,a1,a2,a3,za) + trian(om,b1,b2,b3,zb) &
                      + trian(om,c1,c2,c3,zc)
         ENDDO
      END SELECT          

! to put anzac into the spectrum       
      zdf=z_1/om_sha; idf=om_1/om_sha; spe(idf)=spe(idf)+zdf

       PRINT*,"NOMALIZING"
! calculating initial norma
      anor =  om_sha*SUM(spe(1:nfu))
! rescaling the spectrum to intended norma
      spe(1:nfu) = (intended_norma/anor) * spe(1:nfu)
      za = za * (intended_norma/anor) 
      zb = zb * (intended_norma/anor)
      zc = zc * (intended_norma/anor)
      PRINT*,"Now norma: ", om_sha*SUM(spe(1:nfu)) 
      PRINT*,"Now anzac weight: ", z_1 *(intended_norma/anor)
! writing spectrum      
      OPEN(4,file='spe.dat')
      DO i=1,nfu
         WRITE(4,*)omeg(i),spe(i)
      ENDDO
      CLOSE(4)
      
! TRANSFORMING INTO MODULATED A^{tilde}(omega) SPECTRUM for phononic
      SELECT CASE(kernel_type)
      CASE(0, 1, 2, 4, 5, 6, 7)
            CONTINUE 
      CASE(3); ! making / spe_ti(omega) =
                    ! coth(beta*omega/2) spe(omega) /
         DO  i=2,nfu
            e1=EX(0.5d0*beta*omeg(i)); 
            e2=1.0d0/e1
            bukil = (e1+e2) / (e1-e2); !PRINT*,"bukil ",bukil
            spe_ti(i)=spe(i)*bukil
         ENDDO
         anor_tilda=0.0d0         
         DO  i=2,nfu ! calculating new norma for A^{tilde}(omega) 
            anor_tilda = anor_tilda + (spe_ti(i-1)+spe_ti(i))*0.5*om_sha
         ENDDO
         OPEN(4,file='spe_tilda.dat')
         DO i=1,nfu
            WRITE(4,*)omeg(i),spe_ti(i)
         ENDDO
         CLOSE(4)
      END SELECT    

! SETTING THE CORRELATION FUNCTION 
! setting times or matsubara frequencies
      SELECT CASE(kernel_type)
         CASE(0, 1, 2, 3) 
            t_sha=time/ntim**2
            DO i=1,ntim
               ta(i)=((i-1)**2)*t_sha 
            ENDDO 
         CASE(4)
            t_sha=time/ntim**2
            DO i=1,ntim
               ta(i)=((i-1)**2)*t_sha 
            ENDDO 
            DO i=-n_matsu,n_matsu
               O_n(i) = CMPLX( 0.0d0 , (pi/beta)*(2*i+1) )
            ENDDO
         CASE(5)
            DO i=1,ntim
               ta(i)=((i-1)**2)*t_sha 
            ENDDO 
            DO i=-n_matsu,n_matsu
               O_n(i) = CMPLX( 0.0d0 , (pi/beta)*(2*i) )
            ENDDO
          CASE(6) 
            t_sha_2=time_2/ntim_2**2
            DO i=1,ntim_2
               ta_2(i)=((i-1)**2)*t_sha_2 
            ENDDO 
          CASE(7) 
            t_sha=time/ntim**2
            DO i=1,ntim
               ta(i)=((i-1)**2)*t_sha 
            ENDDO 
            t_sha_2=time_2/ntim_2**2
            DO i=1,ntim_2
               ta_2(i)=((i-1)**2)*t_sha_2 
            ENDDO 
         END SELECT    
         
! setting correlator     
         SELECT CASE(kernel_type)
            CASE(0, 1, 2, 3) 
               gr(1:ntim) = 0.0d0
               DO i=1,ntim
                  DO jj=1,nfu
                     SELECT CASE(kernel_type) 
                      CASE(0)
                         gr(i) = gr(i) + & 
                        spe(jj) * EX(-omeg(jj)*ta(i)) * om_sha
                      CASE(1)
                         gr(i) = gr(i) + &
                        spe(jj) * K_OC(omeg(jj),ta(i),beta)*om_sha 
                      CASE(2)
                         gr(i) = gr(i) + &
                        spe(jj) * K_FERMI(omeg(jj),ta(i),beta)*om_sha  
                      CASE(3)
                         gr(i) = gr(i) + &
                        spe_ti(jj) * K_PHON(omeg(jj),ta(i),beta)*om_sha
                     END SELECT        
                  ENDDO 
               ENDDO
            CASE(4)
               DO i=1,ntim
                  DO jj=1,nfu
                      gr(i) = gr(i) + & 
                      spe(jj) * K_FERMI(omeg(jj),ta(i),beta)*om_sha  
                  ENDDO 
               ENDDO
               DO i=-n_matsu,n_matsu ; 
                  o_com_now=O_n(i)
                  G_n(i) = &
                 G_MATS_TRI(za,a1,a2,a3,o_com_now) + &
                 G_MATS_TRI(zb,b1,b2,b3,o_com_now) + &
                 G_MATS_TRI(zc,c1,c2,c3,o_com_now) 
               ENDDO
            CASE(5)   
               DO i=-n_matsu,n_matsu ; 
                  o_com_now=O_n(i)
                  G_n(i) = &
                 G_MATS_TRI(za,a1,a2,a3,o_com_now) + &
                 G_MATS_TRI(zb,b1,b2,b3,o_com_now) + &
                 G_MATS_TRI(zc,c1,c2,c3,o_com_now)
               ENDDO
            CASE(6)
                gr_2(1:ntim_2) = 0.0d0; gi_2(1:ntim_2) = 0.0d0
                DO i=1,ntim_2
                    DO jj=1,nfu
                        gr_2(i) = gr_2(i) + &
                        spe(jj) * EX(-omeg(jj)*ta_2(i)*cos(phi)) * &
                        cos(omeg(jj)*ta_2(i)*sin(phi)) * om_sha
                        gi_2(i) = gi_2(i) - &
                        spe(jj) * EX(-omeg(jj)*ta_2(i)*cos(phi)) * &
                        sin(omeg(jj)*ta_2(i)*sin(phi)) * om_sha
                    ENDDO    
                ENDDO    
            CASE(7)   
                gr_2(1:ntim_2) = 0.0d0; gi_2(1:ntim_2) = 0.0d0
                DO i=1,ntim_2
                    DO jj=1,nfu
                        gr_2(i) = gr_2(i) + &
                        spe(jj) * EX(-omeg(jj)*ta_2(i)*cos(phi)) * &
                        cos(omeg(jj)*ta_2(i)*sin(phi)) * om_sha
                        gi_2(i) = gi_2(i) - &
                        spe(jj) * EX(-omeg(jj)*ta_2(i)*cos(phi)) * &
                        sin(omeg(jj)*ta_2(i)*sin(phi)) * om_sha
                    ENDDO    
                ENDDO    
                gr(1:ntim) = 0.0d0
                DO i=1,ntim
                   DO jj=1,nfu
                      gr(i) = gr(i) + & 
                      spe(jj) * EX(-omeg(jj)*ta(i)) * om_sha
                   ENDDO    
                ENDDO    
         END SELECT 

 
! MAKING ADITIOONAL THINGS DEPENDING ON KERNEL TYPE        
      SELECT CASE(kernel_type)
         CASE(0, 6, 7) 
            CONTINUE   
         CASE(1)
            nor_core=0.0d0 !Calculating \sigma(omega) norma from correlator
            DO i=1,ntim-1
               nor_core=nor_core+0.5d0*(gr(i+1)+gr(i))*(ta(i+1)-ta(i)) 
            ENDDO
            PRINT*," J(tau) norma * pi / 2 for OC:", nor_core*pi/2
            PRINT*,"Norma from sigma(omega): ",  om_sha*SUM(spe(1:nfu)) 
         CASE(2)
            CONTINUE 
         CASE(3)  
            PRINT*,"tilde(A) norma from D(0) : ", gr(1)
            PRINT*,"tilde(A) norma from tilde(A) :", anor_tilda
         CASE(4, 5)   
            ! making the spectrum from ideal COMPLEX FUNCTION
            ! Im(G(Re(omega))) /pi
              DO i=1,nfu
                 o_com_now=CMPLX( omeg(i) , 0.0d0)
                 spe_mats(i)= &
                AIMAG( G_MATS_TRI(za,a1,a2,a3,o_com_now) ) + &
                AIMAG( G_MATS_TRI(zb,b1,b2,b3,o_com_now) )+ &
                AIMAG( G_MATS_TRI(zc,c1,c2,c3,o_com_now) )
                 spe_mats(i) = - spe_mats(i)/pi
              ENDDO
              OPEN(UNIT=4,file='spe_ideal.in')  ! Im(G(omega))/pi
              DO i=1,nfu
                 WRITE(4,*)omeg(i),spe_mats(i)
              ENDDO 
              CLOSE(4)
              OPEN(UNIT=4,file='gta0_mats.in') !G(tau) from spectrum
              DO i=1,ntim
                 WRITE(4,103)ta(i),gr(i)
              ENDDO    
              CLOSE(4)
              OPEN(UNIT=4,FILE="gta_mats.dat") ! G(tau) inverse Fourier from Matsubara
              DO i=1,ntim
                 ta_compl=CMPLX(ta(i),0.0d0)
                 G_from_mats(i)=CMPLX(0.0d0,0.0d0)  
                 DO j=-n_matsu,n_matsu
                    G_from_mats(i) = G_from_mats(i) + &
                   EXP(-O_n(j)*ta_compl)*G_n(j)  
                 ENDDO
                 G_from_mats(i) = G_from_mats(i)/beta
                 WRITE(4,*)ta(i), &
                REAL(G_from_mats(i)),AIMAG(G_from_mats(i)) 
             ENDDO
             CLOSE(4)
             
      END SELECT    
      
! WRITING GREEN OR CORRELATION FUNCTION  
      SELECT CASE(kernel_type)
         CASE(0, 1, 2, 3) ! writing imaginary test file for spectral analysis 
            OPEN(4,file='infloa.in')
            WRITE(4,*)ntim
            DO i=1,ntim
               WRITE(4,103)ta(i),gr(i),sigma(i) 
            ENDDO    
            CLOSE(4)
         CASE(4, 5) ! writing matsubara test file for spectral analysis 
            OPEN(UNIT=4,file='matsubara.in')
            WRITE(4,*)n_matsu+1
            DO i=0,n_matsu
               WRITE(4,*)i+1,REAL(G_n(i)),AIMAG(G_n(i)),sigma(i)
            ENDDO
            CLOSE(4)
            OPEN(UNIT=4,file='matsu_see.in')
            DO i=0,n_matsu
               WRITE(4,*)i+1,REAL(G_n(i)),AIMAG(G_n(i)),sigma(i)
            ENDDO
            CLOSE(4)
         CASE(6)    
            OPEN(4,file='angle_tau.in')
            WRITE(4,*)ntim_2*2
            DO i=1,ntim_2
               WRITE(4,103)ta_2(i),gr_2(i),ABS(sigma_2(i))+1.0d-10 
            ENDDO    
            DO i=1,ntim_2
               WRITE(4,103)ta_2(i),gi_2(i),ABS(sigma_2(i))+1.0d-10
            ENDDO    
            CLOSE(4)
         CASE(7)    
            OPEN(4,file='imag_angle_tau.in')
            WRITE(4,*)ntim_2*2
            DO i=1,ntim_2
               WRITE(4,103)ta_2(i),gr_2(i),ABS(sigma_2(i))+1.0d-10 
            ENDDO    
            DO i=1,ntim_2
               WRITE(4,103)ta_2(i),gi_2(i),ABS(sigma_2(i))+1.0d-10 
            ENDDO    
            WRITE(4,*)ntim
            DO i=1,ntim
               WRITE(4,103)ta(i),gr(i),sigma(i)+1.0d-10 
            ENDDO    
            CLOSE(4)
      END SELECT
      
      END


!**************************************************************
!     T R I A N G L E
!-------------------------------------------------------------
      REAL*8 FUNCTION TRIAN(x,a1,a2,a3,z_tot)
      IMPLICIT NONE;
      REAL*8,INTENT(IN) :: x,a1,a2,a3,z_tot
      REAL*8 :: he
      IF(.NOT. ( a1<a2 .AND. a2<a3 ))THEN;
       PRINT*,a1,a2,a3; STOP;
      ENDIF
      he = 2.0d0*z_tot/(a3-a1)
      IF(x>a1.and.x<a2) THEN
        trian = (he/(a2-a1))*(x-a1)
      ELSE IF(x>=a2.and.x<a3) THEN
        trian = he - (he/(a3-a2))*(x-a2)
      ELSE
        trian = 0.0d0
      ENDIF
      END FUNCTION TRIAN

!--------------------------------------------------------------------
! Problem avoiding exponent
!--------------------------------------------------------------------
      REAL*8 FUNCTION EX(x)
      IMPLICIT NONE
      REAL*8,INTENT(IN) :: x
      REAL*8,PARAMETER  :: ex_ma=650.0d0
      REAL*8,PARAMETER ::  big=1.956199921370272D+282
      REAL*8,PARAMETER ::  sma=5.111951948651156D-283
      IF      ( x>ex_ma) THEN;  ex = big 
      ELSE IF (-x>ex_ma) THEN;  ex = sma
      ELSE;                     ex = EXP(x); END IF; RETURN
      END FUNCTION EX
!....................................................................

!**************************************************************
!     K E R N E L for optical conducutivity
!-------------------------------------------------------------
      REAL*8 FUNCTION K_OC(ome,tau,beta)
      IMPLICIT NONE;
      REAL*8,EXTERNAL :: EX
      REAL*8,PARAMETER :: pi=3.1415927d0
      REAL*8,INTENT(IN) :: ome,tau,beta
      REAL*8 ::e1,e2,e3,pr1
      e1=EX(-ome*tau); e2=EX(-ome*beta)
      e3=EX(-ome*(beta-tau))
      pr1 = e1 + e3; pr1 =  pr1 / pi
      IF(ABS(ome*beta)>1.0d-10)THEN;
        K_OC = pr1 * ( ome / (1.0d0-e2) ) 
      ELSE;
        K_OC = pr1 / beta
      ENDIF;
      END FUNCTION K_OC
!------------------------------------
      
!**************************************************************
!     K E R N E L for Fermi function
!-------------------------------------------------------------
      REAL*8 FUNCTION K_FERMI(ome,tau,beta)
      IMPLICIT NONE;
      REAL*8,EXTERNAL :: EX
      REAL*8,INTENT(IN) :: ome,tau,beta
      REAL*8 ::e1, e2
      e1=EX( - ome * tau ); e2=EX( - ome * beta)
      K_FERMI = e1 / ( 1.0d0 + e2 ) 
      END FUNCTION K_FERMI
!------------------------------------
      
      
!**************************************************************
!     K E R N E L for transformed bosons
!-------------------------------------------------------------
      REAL*8 FUNCTION K_PHON(ome,tau,beta)
      IMPLICIT NONE;
      REAL*8,EXTERNAL :: EX
      REAL*8,INTENT(IN) :: ome,tau,beta
      REAL*8 ::e1,e2,e3,e4,pr1
      e1=EX( ome*((0.5d0*beta)-tau) ); e2=EX(ome*0.5d0*beta)
      e3=1.0d0/e1; e4=1.0d0/e2
      IF(ABS(ome*beta*0.5d0)>1.0d-10)THEN;
        K_PHON = (e1+e3) / (e2+e4) 
      ELSE;
        K_PHON = 1.0d0
      ENDIF;
      END FUNCTION K_PHON
!------------------------------------

!**************************************************************
!     T R I A N G L E integration for Matsubara
!-------------------------------------------------------------
      COMPLEX FUNCTION G_mats_tri(Norm,x_1,x_2,x_3,omega_n)
      REAL*8,INTENT(IN) :: Norm,x_1,x_2,x_3
      COMPLEX,INTENT(IN) :: omega_n
      COMPLEX :: term1,term2,NNorm,xx_1,xx_2,xx_3,delta
      
      delta=CMPLX(0.0d0, 1.0d-10)

      NNorm=CMPLX(Norm,0.0d0)
      xx_1=CMPLX(x_1,0.0d0)+delta
      xx_2=CMPLX(x_2,0.0d0)+delta
      xx_3=CMPLX(x_3,0.0d0)+delta

      term1 = LOG( (omega_n-xx_1) / (omega_n-xx_2) ) 
      term1 = term1 * (omega_n-xx_1) / (x_2-x_1)

      term2 = LOG( (omega_n-xx_2) / (omega_n-xx_3) )
      term2 = term2 * (omega_n-xx_3) / (x_2-x_3) 

      G_mats_tri = term1 + term2

      G_mats_tri = - G_mats_tri * (2.0d0*NNorm) / (x_3-x_1) 
      
      END FUNCTION G_mats_tri
!.............................................................

  